program Atrybuty2;

uses
  RTTI, System.SysUtils, TypInfo;

type
  AtrybutTestowy = class(TCustomAttribute);

  [AtrybutTestowy]
  TWszędzieAtrybuty = class
    private
      [AtrybutTestowy]
      FWłaściwość: Extended;
      procedure UstawWłaściwość(const Wartość: Extended);
    public
      [AtrybutTestowy]
      procedure ZróbTo([AtrybutTestowy]aTekst: string);
      [AtrybutTestowy]
      function ZróbTamto([AtrybutTestowy]aObiekt: TObject): integer;
      [AtrybutTestowy]
      property JakaśWłaściwość: Extended read FWłaściwość write UstawWłaściwość;
  end;

procedure TWszędzieAtrybuty.UstawWłaściwość(const Wartość: Extended);
begin
  FWłaściwość := Wartość;
end;

procedure TWszędzieAtrybuty.ZróbTo([AtrybutTestowy]aTekst: string);
begin
end;

function TWszędzieAtrybuty.ZróbTamto([AtrybutTestowy]aObiekt: TObject): integer;
begin
end;


procedure PokażWszystkieAtrybuty;
var
  Kontekst: TRttiContext;
  TymczKlasa: TRttiType;
  TymczAtrybut: TCustomAttribute;
  TymczAtrybut1: TCustomAttribute;
  TymczPole: TRttiField;
  TymczMetoda: TRttiMethod;
  TymczParam: TRttiParameter;
  TymczWłaściwość: TRttiProperty;
begin
  // Klasa
  TymczKlasa := Kontekst.GetType(TWszędzieAtrybuty);
  WriteLn('TWszędzieAtrybuty ma następujące atrybuty:');

  for TymczAtrybut in TymczKlasa.GetAttributes do
  begin
    WriteLn(' Atrybut klasy: ', TymczAtrybut.ToString);
  end;
  WriteLn;
  // Pola
  for TymczPole in TymczKlasa.GetFields do
  begin
    WriteLn('Pole ', TymczPole.Name, ' ma następujące atrybuty:');
    for TymczAtrybut in TymczPole.GetAttributes do
    begin
      WriteLn(' ', TymczAtrybut.ToString);
    end;
  end;
  WriteLn;
  // Metody
  for TymczMetoda in TymczKlasa.GetMethods do
  begin
    for TymczAtrybut in TymczMetoda.GetAttributes do
    begin
      WriteLn('Metoda ', TymczMetoda.Name, ' ma atrybut ', TymczAtrybut.ToString, '.');
      for TymczParam in TymczMetoda.GetParameters do
      begin
        for TymczAtrybut1 in TymczParam.GetAttributes do
        begin
          WriteLn(' Parametr ', TymczParam.Name, ' ma atrybut ', TymczAtrybut1.ToString, '.');
        end;
        if TymczMetoda.ReturnType <> nil then
        begin
          WriteLn(' Metoda ', TymczMetoda.Name, ' jest funkcją zwracającą typ ', TymczMetoda.ReturnType.Name, '.');
        end else
        begin
          WriteLn(' Metoda ', TymczMetoda.Name, ' jest procedurą.');
        end;
      end;
    end;
  end;
  WriteLn;
  // Właściwości
  for TymczWłaściwość in TymczKlasa.GetProperties do
  begin
    for TymczAtrybut in TymczWłaściwość.GetAttributes do
    begin
      WriteLn('Właściwość ', TymczWłaściwość.Name, ' ma atrybut ', TymczAtrybut.ToString, '.');
    end;
  end;
end;

var
  WA: TWszędzieAtrybuty;
begin
  WA := TWszędzieAtrybuty.Create;
  PokażWszystkieAtrybuty;
  ReadLn;
end.